package w83a.w83aDAO;

import java.util.HashMap;
import java.util.Map;


public abstract class W83aFactoriaDAO  {

	private static Map implementaciones=new HashMap();
	
	//DISPATCH IMPLEMENTACIONES
	private static Object get(String clase) throws Exception{
		Object objeto = W83aFactoriaDAO.implementaciones.get(clase);		
		if(objeto==null){
			 if("comunes".equals(clase)){
				objeto = W83aComunesDAO.class.newInstance();
			}else if ("centroTrabajo".equals(clase))
			{
				objeto = W83aCentroTrabajoDAO.class.newInstance();
			}
			else if ("lotesPreavisos".equals(clase))
			{
				objeto = W83aLotesPreavisosDAO.class.newInstance();
			}else if("resultados".equals(clase)){
				objeto = W83aResultadosDAO.class.newInstance();
			}else if("documentacion".equals(clase)){
				objeto = W83aDocumentacionDAO.class.newInstance();
			}else if("acta".equals(clase)){
				objeto = W83aActaDAO.class.newInstance();
			}else if("incidencia".equals(clase)){
				objeto = W83aIncidenciasDAO.class.newInstance();
			}else if ("preavisos".equals(clase)){
				objeto = W83aPreavisosDAO.class.newInstance();		
			}else if("impugnacion".equals(clase)){
				objeto = W83aImpugnacionesDAO.class.newInstance();
			}else if("sindicatos".equals(clase)){
				objeto = W83aSindicatosDAO.class.newInstance();
			}else{
				W83aFactoriaDAO.implementaciones.put(clase,objeto);
			}
		}
		return (Object)objeto;
	}
	
	//FIN DISPATCH IMPLEMENTACIONES
	
	public static W83aIComunesDAO getComunesDAO() throws Exception{
		return (W83aIComunesDAO)W83aFactoriaDAO.get("comunes");
	}
	public static W83aICentroTrabajoDAO getCentroTrabajoDAO() throws Exception{
		return (W83aICentroTrabajoDAO)W83aFactoriaDAO.get("centroTrabajo");
	}
	public static W83aILotesPreavisosDAO getLotesPreavisosDAO() throws Exception{
		return (W83aILotesPreavisosDAO)W83aFactoriaDAO.get("lotesPreavisos");
	}
	public static W83aIResultadosDAO getResultadosDAO() throws Exception{
		return (W83aIResultadosDAO)W83aFactoriaDAO.get("resultados");
	}
	public static W83aIDocumentacionDAO getDocumentacionDAO() throws Exception{
		return (W83aIDocumentacionDAO)W83aFactoriaDAO.get("documentacion");
	}
	public static W83aIActaDAO getActaDAO() throws Exception{
		return (W83aIActaDAO)W83aFactoriaDAO.get("acta");
	}
	public static W83aIIncidenciasDAO getIncidenciaDAO() throws Exception{
		return (W83aIIncidenciasDAO)W83aFactoriaDAO.get("incidencia");
	}
	public static W83aIPreavisosDAO getPreavisosDAO() throws Exception{
		return (W83aIPreavisosDAO)W83aFactoriaDAO.get("preavisos");
	}
	public static W83aIImpugnacionesDAO getImpugnacionesDAO() throws Exception{
		return (W83aIImpugnacionesDAO)W83aFactoriaDAO.get("impugnacion");
	}
	public static W83aISindicatosDAO getSindicatosDAO() throws Exception{
		return (W83aISindicatosDAO)W83aFactoriaDAO.get("sindicatos");
	}
}
